<?php
require_once "auth.php"; // <--- ESTO DEBE SER LA LÍNEA 1
require_once '../config/db.php';

// SEGURIDAD PRO: Solo Admin crea usuarios
if (!isset($_SESSION['user_role']) || $_SESSION['user_role'] !== 'admin') {
    header("Location: dashboard.php?error=access_denied");
    exit;
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $full_name = $_POST['full_name'];
    $email = $_POST['email'];
    $password = password_hash($_POST['password'], PASSWORD_DEFAULT); // Encriptación obligatoria al crear
    $role = $_POST['role'];
    $phone = $_POST['phone'];

    $sql = "INSERT INTO users (full_name, email, password_hash, role, phone, created_at) VALUES (?, ?, ?, ?, ?, NOW())";
    $pdo->prepare($sql)->execute([$full_name, $email, $password, $role, $phone]);
    
    header("Location: usuarios.php?status=created");
    exit;
}

require_once 'includes/header.php';
require_once 'includes/sidebar.php';
?>

<div class="flex-1 flex flex-col h-full overflow-hidden relative">
    <?php require_once 'includes/navbar.php'; ?>

    <main class="flex-1 overflow-x-hidden overflow-y-auto bg-brand-light dark:bg-[#080808] p-4 md:p-8">
        <div class="max-w-3xl mx-auto">
            <div class="flex items-center gap-4 mb-8">
                <a href="usuarios.php" class="w-10 h-10 flex items-center justify-center rounded-full bg-white dark:bg-brand-dark border border-gray-200 dark:border-white/10 text-gray-500 hover:text-brand-red transition-all shadow-sm">
                    <i class="ri-arrow-left-line text-xl"></i>
                </a>
                <div>
                    <span class="text-brand-red font-black text-[10px] uppercase tracking-widest">Gestión de Accesos</span>
                    <h1 class="font-display font-black text-3xl dark:text-white uppercase tracking-tighter">Nuevo Usuario</h1>
                </div>
            </div>

            <form method="POST" class="bg-white dark:bg-brand-dark p-8 md:p-12 rounded-[2.5rem] border border-gray-100 dark:border-white/5 shadow-2xl space-y-8">
                
                <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
                    <div class="space-y-2">
                        <label class="block text-[10px] font-black text-gray-400 uppercase tracking-widest ml-1">Nombre Completo</label>
                        <input type="text" name="full_name" placeholder="Ej. Juan Pérez" required 
                               class="w-full bg-gray-50 dark:bg-black/40 border border-gray-200 dark:border-white/5 rounded-2xl px-5 py-4 dark:text-white focus:ring-2 focus:ring-brand-red/20 focus:border-brand-red outline-none transition-all">
                    </div>
                    <div class="space-y-2">
                        <label class="block text-[10px] font-black text-gray-400 uppercase tracking-widest ml-1">Correo Corporativo</label>
                        <input type="email" name="email" placeholder="usuario@jfd.com" required 
                               class="w-full bg-gray-50 dark:bg-black/40 border border-gray-200 dark:border-white/5 rounded-2xl px-5 py-4 dark:text-white focus:ring-2 focus:ring-brand-red/20 focus:border-brand-red outline-none transition-all">
                    </div>
                </div>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
                    <div class="space-y-2">
                        <label class="block text-[10px] font-black text-gray-400 uppercase tracking-widest ml-1">Contraseña Inicial</label>
                        <input type="password" name="password" placeholder="••••••••" required
                               class="w-full bg-gray-50 dark:bg-black/40 border border-gray-200 dark:border-white/5 rounded-2xl px-5 py-4 dark:text-white focus:ring-2 focus:ring-brand-red/20 focus:border-brand-red outline-none transition-all">
                    </div>
                    <div class="space-y-2">
                        <label class="block text-[10px] font-black text-gray-400 uppercase tracking-widest ml-1">Privilegios de Sistema</label>
                        <select name="role" class="w-full bg-gray-50 dark:bg-black/40 border border-gray-200 dark:border-white/5 rounded-2xl px-5 py-4 dark:text-white outline-none focus:ring-2 focus:ring-brand-red/20 focus:border-brand-red transition-all cursor-pointer">
                            <option value="editor">Editor de Contenido</option>
                            <option value="admin">Administrador Master</option>
                        </select>
                    </div>
                </div>

                <div class="space-y-2">
                    <label class="block text-[10px] font-black text-gray-400 uppercase tracking-widest ml-1">Teléfono / WhatsApp (Opcional)</label>
                    <input type="text" name="phone" placeholder="+51 999..." 
                           class="w-full bg-gray-50 dark:bg-black/40 border border-gray-200 dark:border-white/5 rounded-2xl px-5 py-4 dark:text-white focus:ring-2 focus:ring-brand-red/20 focus:border-brand-red outline-none transition-all">
                </div>

                <div class="pt-4">
                    <button type="submit" class="w-full bg-brand-red hover:bg-brand-red_hover text-white font-black uppercase py-5 rounded-2xl shadow-xl shadow-brand-red/30 transition-all transform active:scale-[0.98] tracking-widest">
                        Crear Nuevo Usuario
                    </button>
                </div>
            </form>
        </div>
    </main>
</div>

<?php require_once 'includes/footer.php'; ?>